/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class NACBoard
extends JPanel
implements MouseInputListener {
    int FINNISH = 976;
    int ENGLISH = 590;
    int WIDTH = 30;
    int HEIGHT = 30;
    int BLANK = 0;
    int CROSS = 1;
    int ZERO = 2;
    int EDGE = 3;
    int COMPPLAYER = 1;
    int TWOPLAYERS = 2;
    int STARTED = 1;
    int NOTSTARTED = 0;
    private boolean appletVer;
    private int language;
    private NACFrame ownerGameFrame;
    public int computerPlayer;
    private Image backgroundImage;
    private MediaTracker tracker;
    private int[][] boardState = new int[this.WIDTH + 2][this.HEIGHT + 2];
    private int gameStarted;
    private int squareWidth;
    private int lineThickness;
    private int turnSignX;
    private int turnSignY;
    private String turnText;
    private int turnTextX;
    private int turnTextY;
    private String winnerText;
    private int winnerTextX;
    private int winnerTextY;
    private int turn;
    private int boardX;
    private int boardY;
    private int lastX;
    private int lastY;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private int ext1X;
    private int ext1Y;
    private int ext2X;
    private int ext2Y;
    private int midX;
    private int midY;
    private int player;
    private int winner = this.BLANK;

    public NACBoard(NACFrame nACFrame, int n, int n2) {
        if (n2 != 259) {
            System.exit(0);
        }
        this.ownerGameFrame = nACFrame;
        this.language = n;
        this.clear();
        this.addMouseListener(this);
        if (this.ownerGameFrame.language == this.ENGLISH) {
            this.turnText = "Next :";
            this.winnerText = "Winner ! ";
        }
        if (this.ownerGameFrame.language == this.FINNISH) {
            this.turnText = "Seuraava : ";
            this.winnerText = "Voittaja ! ";
        }
        this.setBackground(Color.white);
        this.backgroundImage = null;
        if (this.ownerGameFrame.appletVersion) {
            try {
                this.backgroundImage = this.ownerGameFrame.parent.getImage(new URL("http://www.cs.helsinki.fi/u/phiipakk/NACBgr.jpg"));
            }
            catch (Exception exception) {
                this.backgroundImage = null;
            }
        } else {
            this.backgroundImage = Toolkit.getDefaultToolkit().getImage("NACBgr.jpg");
        }
        this.tracker = new MediaTracker(this);
        if (this.backgroundImage != null) {
            this.tracker.addImage(this.backgroundImage, 0);
            try {
                this.tracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear() {
        int n;
        this.turn = this.CROSS;
        this.winner = this.BLANK;
        this.gameStarted = this.NOTSTARTED;
        this.boardX = 0;
        this.boardY = 0;
        this.lastX = 0;
        this.lastY = 0;
        int n2 = 1;
        while (n2 <= this.WIDTH) {
            n = 1;
            while (n <= this.HEIGHT) {
                this.boardState[n2][n] = this.BLANK;
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 <= this.WIDTH + 1) {
            this.boardState[n2][0] = this.EDGE;
            this.boardState[n2][this.HEIGHT + 1] = this.EDGE;
            ++n2;
        }
        n = 0;
        while (n <= this.HEIGHT + 1) {
            this.boardState[0][n] = this.EDGE;
            this.boardState[this.WIDTH + 1][n] = this.EDGE;
            ++n;
        }
    }

    private void drawMarkerAt(int n, int n2, int n3, Graphics2D graphics2D) {
        this.drawMarker(n * this.squareWidth, this.squareWidth / 2 + n2 * this.squareWidth, n3, graphics2D);
    }

    private void drawMarker(int n, int n2, int n3, Graphics2D graphics2D) {
        int n4;
        int n5;
        if (n3 == this.CROSS) {
            n4 = n5 = this.squareWidth / 6;
            if (this.squareWidth >= 18) {
                ++n4;
            }
            if (this.squareWidth == 19) {
                --n5;
                --n4;
            }
            graphics2D.setColor(new Color(0.0f, 0.2f, 0.4f));
            graphics2D.setStroke(new BasicStroke(this.lineThickness, 1, 0));
            graphics2D.draw(new Line2D.Double(n + n4, n2 + n4, n + this.squareWidth - n5, n2 + this.squareWidth - n5));
            graphics2D.draw(new Line2D.Double(n + n4, (double)(n2 + this.squareWidth) - ((double)n5 - 0.5), n + this.squareWidth - n5, n2 + n4));
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
            graphics2D.draw(new Line2D.Double((double)(n + n5) + 1.5, n2 + this.squareWidth - n5, n + this.squareWidth - n4, n2 + n4 + 1));
            if (this.squareWidth > 17) {
                graphics2D.draw(new Line2D.Double(n + n5, n2 + this.squareWidth - n5 - 2, n + this.squareWidth - n4 - 1, n2 + n5));
            }
        }
        if (n3 == this.ZERO) {
            graphics2D.setColor(new Color(0.3f, 0.0f, 0.3f));
            n5 = 0;
            n4 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = 0;
            int n23 = 0;
            int n24 = 0;
            int n25 = 0;
            int n26 = 0;
            n5 = n + this.squareWidth * 16 / 32;
            n8 = n + this.squareWidth * 27 / 32;
            n11 = n2 + this.squareWidth * 7 / 16;
            n12 = n2 + this.squareWidth * 19 / 32;
            n13 = n2 + this.squareWidth * 27 / 32;
            n15 = n2 + this.squareWidth * 14 / 32;
            n16 = n + this.squareWidth * 7 / 16;
            n17 = n + this.squareWidth * 3 / 8;
            n19 = n + this.squareWidth * 5 / 8;
            n20 = n + this.squareWidth * 5 / 8 + 1;
            n21 = n + this.squareWidth * 5 / 8;
            n23 = n2 + this.squareWidth * 5 / 8;
            n18 = n + this.squareWidth * 7 / 16;
            n24 = n2 + this.squareWidth * 5 / 8 + 1;
            n25 = n2 + this.squareWidth * 5 / 8;
            n22 = n2 + this.squareWidth * 3 / 8;
            n26 = n2 + this.squareWidth * 3 / 8 + 1;
            if (this.squareWidth < 13) {
                n4 = n + this.squareWidth * 7 / 32;
                n6 = n + this.squareWidth * 15 / 32;
                n7 = n + this.squareWidth * 21 / 32;
                n9 = n + this.squareWidth * 21 / 32;
                n10 = n2 + this.squareWidth * 3 / 16;
                n14 = n2 + this.squareWidth * 21 / 32;
            }
            if (this.squareWidth >= 13 && this.squareWidth <= 15) {
                n10 = n2 + this.squareWidth * 4 / 15;
                n14 = n2 + this.squareWidth * 20 / 32;
                n4 = n + this.squareWidth * 8 / 32;
                n6 = n + this.squareWidth * 14 / 32;
                n7 = n + this.squareWidth * 20 / 32;
                n9 = n + this.squareWidth * 20 / 32;
            }
            if (this.squareWidth > 15) {
                n4 = n + this.squareWidth * 7 / 32;
                n6 = n + this.squareWidth * 14 / 32;
                n7 = n + this.squareWidth * 21 / 32;
                n9 = n + this.squareWidth * 21 / 32;
                n10 = n2 + this.squareWidth * 3 / 16;
                n14 = n2 + this.squareWidth * 21 / 32;
                n15 = n2 + this.squareWidth * 13 / 32;
            }
            switch (this.squareWidth) {
                case 13: {
                    break;
                }
                case 15: {
                    --n10;
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    --n5;
                    --n6;
                    --n11;
                    ++n12;
                    break;
                }
                case 18: {
                    --n5;
                    break;
                }
                case 19: {
                    ++n19;
                    --n22;
                    ++n25;
                }
            }
            int[] nArray = new int[]{--n5, --n4, n4, --n6, n7, ++n8, n8, n9};
            int[] nArray2 = new int[]{--n10, --n11, ++n12, ++n13, n13, n14, n15, n10};
            int[] nArray3 = new int[]{n16, --n17, n17, n18, --n19, ++n20, n20, n19};
            int[] nArray4 = new int[]{--n22, n2 + this.squareWidth * 3 / 8 + 1, --n23, ++n24, n24, --n25, --n26, n22};
            graphics2D.draw(new Polygon(nArray, nArray2, 8));
            nArray2[2] = nArray2[2] + 1;
            nArray[5] = nArray[5] + 1;
            graphics2D.fill(new Polygon(nArray, nArray2, 8));
            if (n2 > this.squareWidth) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setColor(Color.lightGray);
            }
            graphics2D.draw(new Polygon(nArray3, nArray4, 8));
            nArray4[1] = nArray4[1] + 1;
            nArray4[2] = nArray4[2] + 1;
            nArray4[5] = nArray4[5] + 1;
            graphics2D.fill(new Polygon(nArray3, nArray4, 8));
        }
    }

    private void markWinner(Graphics2D graphics2D) {
        this.drawMarker(this.turnSignX, this.turnSignY, this.winner, graphics2D);
        graphics2D.setColor(Color.black);
        graphics2D.setFont(new Font("Dialog", 1, 12));
        graphics2D.drawString(this.winnerText, this.winnerTextX, this.winnerTextY);
        this.turn = this.BLANK;
        graphics2D.setColor(new Color(0.0f, 0.73f, 0.0f));
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        if (this.startY == this.endY) {
            graphics2D.draw(new Line2D.Double(this.startX * this.squareWidth + this.squareWidth / 2, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth * 3 / 4, this.endX * this.squareWidth + this.squareWidth / 2 + 1, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth * 3 / 4));
            graphics2D.draw(new Line2D.Double(this.startX * this.squareWidth + this.squareWidth / 2, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth / 4 + 1, this.endX * this.squareWidth + this.squareWidth / 2 + 1, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth / 4 + 1));
            graphics2D.drawArc(this.startX * this.squareWidth + this.squareWidth / 4 + 1, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth / 4 + 1, this.squareWidth / 2 - 1, this.squareWidth / 2 - 1, 90, 180);
            graphics2D.drawArc(this.endX * this.squareWidth + this.squareWidth / 4 + 1, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth / 4 + 1, this.squareWidth / 2 - 1, this.squareWidth / 2 - 1, 270, 180);
        }
        if (this.startX == this.endX) {
            graphics2D.draw(new Line2D.Double(this.startX * this.squareWidth + this.squareWidth * 3 / 8 - 1, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth / 2 - 1, this.endX * this.squareWidth + this.squareWidth * 3 / 8 - 1, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth / 2 + 1));
            graphics2D.draw(new Line2D.Double(this.startX * this.squareWidth + this.squareWidth * 5 / 8 + 2, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth / 2 - 1, this.endX * this.squareWidth + this.squareWidth * 5 / 8 + 2, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth / 2 + 1));
            int n = this.squareWidth * 10 / 24;
            int n2 = this.squareWidth > 17 ? n * 5 / 8 : n * 6 / 8;
            graphics2D.drawArc(this.startX * this.squareWidth + this.squareWidth * 11 / 32, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth / 3, n - 1, n * 5 / 8, 0, 180);
            graphics2D.drawArc(this.endX * this.squareWidth + this.squareWidth * 11 / 32, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth / 2, n, n2, 183, 180);
        }
        if (this.startX < this.endX && this.startY < this.endY) {
            graphics2D.draw(new Line2D.Double((this.startX + 1) * this.squareWidth - this.squareWidth / 3 - 1, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth / 3, (this.endX + 1) * this.squareWidth - this.squareWidth / 3 - 1, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth / 3));
            graphics2D.draw(new Line2D.Double(this.startX * this.squareWidth + this.squareWidth / 3 + 1, this.squareWidth / 2 + (this.startY + 1) * this.squareWidth - this.squareWidth / 3, this.endX * this.squareWidth + this.squareWidth / 3 + 1, this.squareWidth / 2 + (this.endY + 1) * this.squareWidth - this.squareWidth / 3));
            graphics2D.drawArc(this.startX * this.squareWidth + this.squareWidth / 4 + 1, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth / 4 + 1, this.squareWidth / 2, this.squareWidth / 2, 46, 180);
            graphics2D.drawArc(this.endX * this.squareWidth + this.squareWidth / 4 + 1, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth / 4 + 1, this.squareWidth / 2, this.squareWidth / 2, 226, 180);
        }
        if (this.startX < this.endX && this.startY > this.endY) {
            graphics2D.draw(new Line2D.Double(this.startX * this.squareWidth + this.squareWidth / 3 + 2, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth / 3 + 1, this.endX * this.squareWidth + this.squareWidth / 3 + 2, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth / 3 + 1));
            graphics2D.draw(new Line2D.Double((this.startX + 1) * this.squareWidth - this.squareWidth / 3 - 3, this.squareWidth / 2 + (this.startY + 1) * this.squareWidth - this.squareWidth / 3, (this.endX + 1) * this.squareWidth - this.squareWidth / 3 - 3, this.squareWidth / 2 + (this.endY + 1) * this.squareWidth - this.squareWidth / 3));
            graphics2D.drawArc(this.startX * this.squareWidth + this.squareWidth / 4 + 2, this.squareWidth / 2 + this.startY * this.squareWidth + this.squareWidth / 4 + 3, this.squareWidth / 2 - 3, this.squareWidth / 2 - 3, 135, 180);
            graphics2D.drawArc(this.endX * this.squareWidth + this.squareWidth / 4 + 3, this.squareWidth / 2 + this.endY * this.squareWidth + this.squareWidth / 4 + 2, this.squareWidth / 2 - 3, this.squareWidth / 2 - 3, 314, 180);
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n2 = dimension.width / (this.WIDTH + 2);
        int n3 = dimension.height / (this.HEIGHT + 2);
        int n4 = this.squareWidth = n2 < n3 ? n2 : n3;
        if (this.squareWidth < 12) {
            this.squareWidth = 12;
        }
        this.lineThickness = this.squareWidth / 6;
        this.turnSignX = this.WIDTH * this.squareWidth;
        this.turnSignY = this.squareWidth / 4;
        this.winnerTextX = this.turnTextX = this.turnSignX;
        String string = System.getProperty("os.name");
        this.turnTextX = this.language == this.ENGLISH ? (string.charAt(0) == 'W' ? this.turnSignX - 32 : this.turnSignX - 42) : (string.charAt(0) == 'W' ? this.turnSignX - 60 : this.turnSignX - 70);
        this.turnTextY = this.squareWidth + 1;
        this.winnerTextX = string.charAt(0) == 'W' ? this.turnSignX - 47 : this.turnSignX - 57;
        this.winnerTextY = this.turnTextY;
        int n5 = dimension.width / 50;
        int n6 = dimension.height / 50;
        int n7 = this.HEIGHT * this.squareWidth + this.squareWidth * 3 / 2;
        if (this.backgroundImage != null) {
            n = 0;
            while (n <= n5) {
                graphics2D.setClip(n * 50, 0, (n + 1) * 50, this.squareWidth * 3 / 2);
                graphics2D.drawImage(this.backgroundImage, n * 50, 0, this);
                graphics2D.setClip(n * 50, n7, (n + 1) * 50, n7 + this.squareWidth * 3 / 2);
                graphics2D.drawImage(this.backgroundImage, n * 50, n7, this);
                int n8 = n7;
                while (n8 < dimension.height) {
                    graphics2D.setClip(n * 50, n8, (n + 1) * 50, n8 + 50);
                    graphics2D.drawImage(this.backgroundImage, n * 50, n8, this);
                    n8 += 50;
                }
                ++n;
            }
        }
        if (this.backgroundImage != null) {
            n = 0;
            while (n <= n6) {
                graphics2D.setClip(0, n * 50, this.squareWidth, (n + 1) * 50);
                graphics2D.drawImage(this.backgroundImage, 0, n * 50, this);
                int n9 = (this.WIDTH + 1) * this.squareWidth;
                while (n9 < dimension.width) {
                    graphics2D.setClip(n9, n * 50, n9 + 50, (n + 1) * 50);
                    graphics2D.drawImage(this.backgroundImage, n9, n * 50, this);
                    n9 += 50;
                }
                ++n;
            }
        }
        graphics2D.setClip(0, 0, dimension.width, dimension.height);
        graphics2D.setColor(new Color(0.15f, 0.15f, 0.15f));
        n = 1;
        while (n <= this.WIDTH + 1) {
            graphics2D.draw(new Line2D.Double(n * this.squareWidth, this.squareWidth + this.squareWidth / 2 + 1, n * this.squareWidth, (this.HEIGHT + 1) * this.squareWidth + this.squareWidth / 2 - 1));
            ++n;
        }
        n = 1;
        while (n <= this.HEIGHT + 1) {
            graphics2D.draw(new Line2D.Double(this.squareWidth + 1, n * this.squareWidth + this.squareWidth / 2, (this.WIDTH + 1) * this.squareWidth - 1, n * this.squareWidth + this.squareWidth / 2));
            ++n;
        }
        n = 1;
        while (n <= this.WIDTH) {
            int n10 = 1;
            while (n10 <= this.HEIGHT) {
                if (this.boardState[n][n10] != this.BLANK) {
                    this.drawMarkerAt(n, n10, this.boardState[n][n10], graphics2D);
                }
                ++n10;
            }
            ++n;
        }
        if (this.turn != this.BLANK) {
            this.drawMarker(this.turnSignX, this.turnSignY, this.turn, graphics2D);
            graphics2D.setColor(Color.black);
            graphics2D.setFont(new Font("Dialog", 1, 12));
            graphics2D.drawString(this.turnText, this.turnTextX, this.turnTextY);
        }
        if (this.winner != this.BLANK) {
            this.markWinner(graphics2D);
        }
    }

    private boolean getBoardXY(int n, int n2) {
        if ((n - this.squareWidth) % this.squareWidth != 0 && (n2 - this.squareWidth / 2) % this.squareWidth != 0 && n > this.squareWidth && n < (this.WIDTH + 1) * this.squareWidth && n2 > this.squareWidth + this.squareWidth / 2 && n2 < this.squareWidth / 2 + (this.HEIGHT + 1) * this.squareWidth) {
            this.boardX = n / this.squareWidth;
            this.boardY = (n2 - this.squareWidth / 2) / this.squareWidth;
            return true;
        }
        return false;
    }

    private void cancelMarker(int n, int n2) {
        if (this.getBoardXY(n, n2) && this.boardX == this.lastX && this.boardY == this.lastY && this.turn != this.BLANK) {
            this.boardState[this.boardX][this.boardY] = this.BLANK;
            this.changeTurn();
            this.lastX = 0;
            this.lastY = 0;
        }
    }

    private void changeTurn() {
        this.turn = this.turn == this.CROSS ? this.ZERO : this.CROSS;
        this.repaint();
    }

    private void checkStraights(int n) {
        int n2;
        int n3;
        this.player = this.BLANK;
        int n4 = n == 5 ? 4 : n;
        this.ext1X = 0;
        this.ext1Y = 0;
        this.ext2X = 0;
        this.ext2Y = 0;
        this.midX = 0;
        this.midY = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        this.startX = 0;
        this.startY = 0;
        int n9 = 1;
        while (n9 <= this.HEIGHT) {
            n3 = 1;
            while (n3 <= this.WIDTH - 4) {
                n2 = 0;
                while (n2 <= n4) {
                    if (this.boardState[n3 + n2][n9] == this.CROSS) {
                        ++n5;
                    }
                    if (this.boardState[n3 + n2][n9] == this.ZERO) {
                        ++n6;
                    }
                    if (this.boardState[n3 + n2][n9] == this.BLANK) {
                        n7 = n3 + n2;
                        n8 = n9;
                    }
                    ++n2;
                }
                if (!(n5 != n && n6 != n || n7 == 0 && n != 5)) {
                    if (n5 == n && (this.player == this.BLANK || this.player == this.CROSS && (this.boardState[this.ext1X][this.ext1Y] == this.ZERO || this.boardState[this.ext2X][this.ext2Y] == this.ZERO) || this.player == this.ZERO && (this.boardState[this.ext1X][this.ext1Y] == this.CROSS || this.boardState[this.ext2X][this.ext2Y] == this.CROSS))) {
                        this.player = this.CROSS;
                        this.startX = n3;
                        this.startY = n9;
                        this.endX = n3 + 4;
                        this.endY = n9;
                        if (n7 != 0) {
                            this.midX = n7;
                            this.midY = n8;
                        }
                        this.ext1X = n3 - 1;
                        this.ext1Y = n9;
                        this.ext2X = n3 + n4 + 1;
                        this.ext2Y = n9;
                    }
                    if (n6 == n && (this.player == this.BLANK || this.player == this.ZERO || this.player == this.CROSS && (this.boardState[n3 - 1][n9] == this.BLANK && this.boardState[n3 + n4 + 1][n9] == this.BLANK || this.boardState[this.ext1X][this.ext1Y] == this.ZERO || this.boardState[this.ext2X][this.ext2Y] == this.ZERO))) {
                        this.player = this.ZERO;
                        this.startX = n3;
                        this.startY = n9;
                        this.endX = n3 + 4;
                        this.endY = n9;
                        if (n7 != 0) {
                            this.midX = n7;
                            this.midY = n8;
                        }
                        this.ext1X = n3 - 1;
                        this.ext1Y = n9;
                        this.ext2X = n3 + n4 + 1;
                        this.ext2Y = n9;
                    }
                }
                n5 = 0;
                n6 = 0;
                n7 = 0;
                n8 = 0;
                ++n3;
            }
            ++n9;
        }
        n9 = 1;
        while (n9 <= this.WIDTH) {
            n3 = 1;
            while (n3 <= this.HEIGHT - 4) {
                n2 = 0;
                while (n2 <= n4) {
                    if (this.boardState[n9][n3 + n2] == this.CROSS) {
                        ++n5;
                    }
                    if (this.boardState[n9][n3 + n2] == this.ZERO) {
                        ++n6;
                    }
                    if (this.boardState[n9][n3 + n2] == this.BLANK) {
                        n7 = n9;
                        n8 = n3 + n2;
                    }
                    ++n2;
                }
                if (!(n5 != n && n6 != n || n7 == 0 && n != 5)) {
                    if (n5 == n && (this.player == this.BLANK || this.player == this.CROSS && (this.boardState[this.ext1X][this.ext1Y] == this.ZERO || this.boardState[this.ext2X][this.ext2Y] == this.ZERO) || this.player == this.ZERO && (this.boardState[this.ext1X][this.ext1Y] == this.CROSS || this.boardState[this.ext2X][this.ext2Y] == this.CROSS))) {
                        this.player = this.CROSS;
                        this.startX = n9;
                        this.startY = n3;
                        this.endX = n9;
                        this.endY = n3 + 4;
                        if (n7 != 0) {
                            this.midX = n7;
                            this.midY = n8;
                        }
                        this.ext1X = n9;
                        this.ext1Y = n3 - 1;
                        this.ext2X = n9;
                        this.ext2Y = n3 + n4 + 1;
                    }
                    if (n6 == n && (this.player == this.BLANK || this.player == this.ZERO || this.player == this.CROSS && (this.boardState[n9][n3 - 1] == this.BLANK && this.boardState[n9][n3 + n4 + 1] == this.BLANK || this.boardState[this.ext1X][this.ext1Y] == this.ZERO || this.boardState[this.ext2X][this.ext2Y] == this.ZERO))) {
                        this.player = this.ZERO;
                        this.startX = n9;
                        this.startY = n3;
                        this.endX = n9;
                        this.endY = n3 + 4;
                        if (n7 != 0) {
                            this.midX = n7;
                            this.midY = n8;
                        }
                        this.ext1X = n9;
                        this.ext1Y = n3 - 1;
                        this.ext2X = n9;
                        this.ext2Y = n3 + n4 + 1;
                    }
                }
                n5 = 0;
                n6 = 0;
                n7 = 0;
                n8 = 0;
                ++n3;
            }
            ++n9;
        }
        n9 = 5;
        while (n9 <= this.HEIGHT) {
            n3 = 1;
            while (n3 <= this.WIDTH - 4) {
                n2 = 0;
                while (n2 <= n4) {
                    if (this.boardState[n3 + n2][n9 - n2] == this.CROSS) {
                        ++n5;
                    }
                    if (this.boardState[n3 + n2][n9 - n2] == this.ZERO) {
                        ++n6;
                    }
                    if (this.boardState[n3 + n2][n9 - n2] == this.BLANK) {
                        n7 = n3 + n2;
                        n8 = n9 - n2;
                    }
                    ++n2;
                }
                if (!(n5 != n && n6 != n || n7 == 0 && n != 5)) {
                    if (n5 == n && (this.player == this.BLANK || this.player == this.CROSS && (this.boardState[this.ext1X][this.ext1Y] == this.ZERO || this.boardState[this.ext2X][this.ext2Y] == this.ZERO) || this.player == this.ZERO && (this.boardState[this.ext1X][this.ext1Y] == this.CROSS || this.boardState[this.ext2X][this.ext2Y] == this.CROSS))) {
                        this.player = this.CROSS;
                        this.startX = n3;
                        this.startY = n9;
                        this.endX = n3 + 4;
                        this.endY = n9 - 4;
                        if (n7 != 0) {
                            this.midX = n7;
                            this.midY = n8;
                        }
                        this.ext1X = n3 - 1;
                        this.ext1Y = n9 + 1;
                        this.ext2X = n3 + n4 + 1;
                        this.ext2Y = n9 - n4 - 1;
                    }
                    if (n6 == n && (this.player == this.BLANK || this.player == this.ZERO || this.player == this.CROSS && (this.boardState[n3 - 1][n9 + 1] == this.BLANK && this.boardState[n3 + n4 + 1][n9 - n4 - 1] == this.BLANK || this.boardState[this.ext1X][this.ext1Y] == this.ZERO || this.boardState[this.ext2X][this.ext2Y] == this.ZERO))) {
                        this.player = this.ZERO;
                        this.startX = n3;
                        this.startY = n9;
                        this.endX = n3 + 4;
                        this.endY = n9 - 4;
                        if (n7 != 0) {
                            this.midX = n7;
                            this.midY = n8;
                        }
                        this.ext1X = n3 - 1;
                        this.ext1Y = n9 + 1;
                        this.ext2X = n3 + n4 + 1;
                        this.ext2Y = n9 - n4 - 1;
                    }
                }
                n5 = 0;
                n6 = 0;
                n7 = 0;
                n8 = 0;
                ++n3;
            }
            ++n9;
        }
        n9 = 1;
        while (n9 <= this.HEIGHT - 4) {
            n3 = 1;
            while (n3 <= this.WIDTH - 4) {
                n2 = 0;
                while (n2 <= n4) {
                    if (this.boardState[n3 + n2][n9 + n2] == this.CROSS) {
                        ++n5;
                    }
                    if (this.boardState[n3 + n2][n9 + n2] == this.ZERO) {
                        ++n6;
                    }
                    if (this.boardState[n3 + n2][n9 + n2] == this.BLANK) {
                        n7 = n3 + n2;
                        n8 = n9 + n2;
                    }
                    ++n2;
                }
                if (!(n5 != n && n6 != n || n7 == 0 && n != 5)) {
                    if (n5 == n && (this.player == this.BLANK || this.player == this.CROSS && (this.boardState[this.ext1X][this.ext1Y] == this.ZERO || this.boardState[this.ext2X][this.ext2Y] == this.ZERO) || this.player == this.ZERO && (this.boardState[this.ext1X][this.ext1Y] == this.CROSS || this.boardState[this.ext2X][this.ext2Y] == this.CROSS))) {
                        this.player = this.CROSS;
                        this.startX = n3;
                        this.startY = n9;
                        this.endX = n3 + 4;
                        this.endY = n9 + 4;
                        if (n7 != 0) {
                            this.midX = n7;
                            this.midY = n8;
                        }
                        this.ext1X = n3 - 1;
                        this.ext1Y = n9 - 1;
                        this.ext2X = n3 + n4 + 1;
                        this.ext2Y = n9 + n4 + 1;
                    }
                    if (n6 == n && (this.player == this.BLANK || this.player == this.ZERO || this.player == this.CROSS && (this.boardState[n3 - 1][n9 - 1] == this.BLANK && this.boardState[n3 + n4 + 1][n9 + n4 + 1] == this.BLANK || this.boardState[this.ext1X][this.ext1Y] == this.ZERO || this.boardState[this.ext2X][this.ext2Y] == this.ZERO))) {
                        this.player = this.ZERO;
                        this.startX = n3;
                        this.startY = n9;
                        this.endX = n3 + 4;
                        this.endY = n9 + 4;
                        if (n7 != 0) {
                            this.midX = n7;
                            this.midY = n8;
                        }
                        this.ext1X = n3 - 1;
                        this.ext1Y = n9 - 1;
                        this.ext2X = n3 + n4 + 1;
                        this.ext2Y = n9 + n4 + 1;
                    }
                }
                n5 = 0;
                n6 = 0;
                n7 = 0;
                n8 = 0;
                ++n3;
            }
            ++n9;
        }
    }

    private void checkBoard() {
        this.checkStraights(5);
        if (this.player != this.BLANK) {
            this.winner = this.player;
            this.turn = this.BLANK;
            this.repaint();
        }
    }

    private void computerMove() {
        Random random = new Random();
        int n = 4;
        do {
            this.checkStraights(n);
        } while (--n > 0 && this.player == this.BLANK);
        if (this.player != this.BLANK) {
            this.boardX = this.midX;
            this.boardY = this.midY;
        } else {
            do {
                this.boardX = random.nextInt(this.WIDTH - 1) + 1;
                this.boardY = random.nextInt(this.HEIGHT - 1) + 1;
            } while (this.boardState[this.boardX][this.boardY] != this.BLANK);
        }
        this.boardState[this.boardX][this.boardY] = this.ZERO;
    }

    private void setMarker(int n, int n2) {
        if (this.turn != this.BLANK && this.getBoardXY(n, n2) && this.boardState[this.boardX][this.boardY] == this.BLANK) {
            if (this.gameStarted == this.NOTSTARTED) {
                this.computerPlayer = this.ownerGameFrame.onePlayer.isSelected() ? this.COMPPLAYER : this.TWOPLAYERS;
                this.gameStarted = this.STARTED;
            }
            this.boardState[this.boardX][this.boardY] = this.turn;
            this.changeTurn();
            this.lastX = this.boardX;
            this.lastY = this.boardY;
            this.checkBoard();
            if (this.computerPlayer == this.COMPPLAYER && this.turn == this.ZERO) {
                this.computerMove();
                this.changeTurn();
                this.lastX = this.boardX;
                this.lastY = this.boardY;
                this.checkBoard();
            }
        }
    }

    public void saveBoard() {
        File file = null;
        if (this.ownerGameFrame.language == this.ENGLISH) {
            file = new File(System.getProperty("user.home") + "/Board.nac");
        }
        if (this.ownerGameFrame.language == this.FINNISH) {
            file = new File(System.getProperty("user.home") + "/Pelilauta.rla");
        }
        if (!file.canWrite()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n = this.ownerGameFrame.onePlayer.isSelected() ? this.COMPPLAYER : this.TWOPLAYERS;
            fileOutputStream.write(n);
            int n2 = 1;
            while (n2 <= this.WIDTH) {
                int n3 = 1;
                while (n3 <= this.HEIGHT) {
                    fileOutputStream.write(this.boardState[n2][n3]);
                    ++n3;
                }
                ++n2;
            }
            fileOutputStream.write(this.turn);
            fileOutputStream.write(this.winner);
            fileOutputStream.write(this.computerPlayer);
            fileOutputStream.write(this.boardX);
            fileOutputStream.write(this.boardY);
            fileOutputStream.write(this.lastX);
            fileOutputStream.write(this.lastY);
            fileOutputStream.write(this.startX);
            fileOutputStream.write(this.startY);
            fileOutputStream.write(this.endX);
            fileOutputStream.write(this.endY);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadBoard() {
        File file = null;
        if (this.ownerGameFrame.language == this.ENGLISH) {
            file = new File(System.getProperty("user.home") + "/Board.nac");
        }
        if (this.ownerGameFrame.language == this.FINNISH) {
            file = new File(System.getProperty("user.home") + "/Pelilauta.rla");
        }
        if (file != null && file.canRead()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                int n = fileInputStream.read();
                if (n == this.COMPPLAYER) {
                    this.ownerGameFrame.onePlayer.setSelected(true);
                } else {
                    this.ownerGameFrame.twoPlayers.setSelected(true);
                }
                int n2 = 1;
                while (n2 <= this.WIDTH) {
                    int n3 = 1;
                    while (n3 <= this.HEIGHT) {
                        this.boardState[n2][n3] = fileInputStream.read();
                        ++n3;
                    }
                    ++n2;
                }
                this.turn = fileInputStream.read();
                this.winner = fileInputStream.read();
                this.computerPlayer = fileInputStream.read();
                this.boardX = fileInputStream.read();
                this.boardY = fileInputStream.read();
                this.lastX = fileInputStream.read();
                this.lastY = fileInputStream.read();
                this.startX = fileInputStream.read();
                this.startY = fileInputStream.read();
                this.endX = fileInputStream.read();
                this.endY = fileInputStream.read();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 16) {
            this.setMarker(mouseEvent.getX(), mouseEvent.getY());
        }
        if ((mouseEvent.getModifiers() & 4) == 4) {
            this.cancelMarker(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

