/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;

public class NACFrame
extends JFrame
implements ActionListener,
WindowListener {
    NACBoard gameBoard;
    Point location = new Point();
    int language;
    boolean appletVersion;
    JApplet parent;
    Insets gameFrameInsets;
    boolean warningBanners;
    ImageIcon NACIcon;
    JDialog infoDialog;
    NACHelpFrame helpFrame;
    JMenuBar mainMenuBar;
    JMenu fileMenu;
    JMenuItem newGame;
    JMenuItem exit;
    JMenu optionsMenu;
    ButtonGroup playersButtonGroup;
    JRadioButtonMenuItem onePlayer;
    JRadioButtonMenuItem twoPlayers;
    JMenu helpMenu;
    JMenuItem help;
    JMenuItem about;

    private void setFinnishTexts() {
        this.setTitle("Ristinolla");
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu("Tiedosto");
        this.newGame = new JMenuItem("Uusi peli");
        this.exit = new JMenuItem("Lopeta");
        this.optionsMenu = new JMenu("Asetukset");
        this.onePlayer = new JRadioButtonMenuItem("Yksinpeli");
        this.twoPlayers = new JRadioButtonMenuItem("Kaksinpeli");
        this.helpMenu = new JMenu("Ohje");
        this.help = new JMenuItem("Ristinollan ohje");
        this.about = new JMenuItem("Tietoa Ristinollasta");
    }

    private void setEnglishTexts() {
        this.setTitle("Noughts and Crosses");
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.newGame = new JMenuItem("New Game");
        this.exit = new JMenuItem("Exit");
        this.optionsMenu = new JMenu("Options");
        this.onePlayer = new JRadioButtonMenuItem("One Player");
        this.twoPlayers = new JRadioButtonMenuItem("Two Players");
        this.helpMenu = new JMenu("Help");
        this.help = new JMenuItem("Help");
        this.about = new JMenuItem("About Noughts and Crosses");
    }

    private void setUpMenuBar(int n) {
        if (n != 2647) {
            System.exit(0);
        }
        this.fileMenu.add(this.newGame);
        this.fileMenu.add(this.exit);
        this.mainMenuBar.add(this.fileMenu);
        this.playersButtonGroup = new ButtonGroup();
        this.playersButtonGroup.add(this.onePlayer);
        this.playersButtonGroup.add(this.twoPlayers);
        this.onePlayer.setSelected(true);
        this.optionsMenu.add(this.onePlayer);
        this.optionsMenu.add(this.twoPlayers);
        this.mainMenuBar.add(this.optionsMenu);
        this.helpMenu.add(this.help);
        this.helpMenu.add(this.about);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
        this.newGame.addActionListener(this);
        this.exit.addActionListener(this);
        this.help.addActionListener(this);
        this.about.addActionListener(this);
    }

    NACFrame(int n, JApplet jApplet, int n2) {
        this.language = n;
        this.appletVersion = jApplet != null;
        this.parent = jApplet;
        if (this.language == 976) {
            this.setFinnishTexts();
        } else {
            this.setEnglishTexts();
        }
        this.addWindowListener(this);
        this.setUpMenuBar(n2);
        this.NACIcon = null;
        if (this.appletVersion) {
            try {
                this.NACIcon = new ImageIcon("http://www.cs.helsinki.fi/u/phiipakk/NACIcon.jpg");
            }
            catch (Exception exception) {}
        } else {
            this.NACIcon = new ImageIcon("NACIcon.jpg");
        }
        if (this.NACIcon != null) {
            ((Frame)this).setIconImage(this.NACIcon.getImage());
        }
        this.gameFrameInsets = this.getInsets();
        this.warningBanners = false;
        try {
            this.warningBanners = !System.getSecurityManager().checkTopLevelWindow(this);
        }
        catch (Exception exception) {
            this.warningBanners = true;
        }
        this.gameBoard = new NACBoard(this, this.language, 259);
        this.getContentPane().add(this.gameBoard);
        if (!this.appletVersion) {
            this.gameBoard.loadBoard();
        }
        if (this.warningBanners && this.appletVersion) {
            ((Component)this).setSize(392, 465);
        } else {
            ((Component)this).setSize(392, 445);
        }
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.location.x = 150;
        this.location.y = 10;
        ((Component)this).setLocation(this.location);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Serializable serializable2;
        Object object = actionEvent.getSource();
        if (object == this.newGame) {
            this.gameBoard.clear();
            this.gameBoard.repaint();
        }
        if (object == this.exit) {
            if (!this.appletVersion) {
                this.gameBoard.saveBoard();
            }
            if (this.helpFrame != null) {
                this.helpFrame.dispose();
            }
            this.dispose();
            if (!this.appletVersion) {
                System.exit(0);
            }
        }
        if (object == this.help) {
            if (this.helpFrame == null) {
                this.helpFrame = new NACHelpFrame(this);
                this.helpFrame.addWindowListener(this);
                this.location = this.getLocation();
                serializable2 = new Dimension();
                serializable = new Dimension();
                serializable2 = this.getSize();
                serializable = this.helpFrame.getSize();
                this.location.x += ((Dimension)serializable2).width / 2 - ((Dimension)serializable).width / 2;
                this.location.y += ((Dimension)serializable2).height / 2 - ((Dimension)serializable).height / 2;
                ((Component)this.helpFrame).setLocation(this.location);
                this.helpFrame.show();
            } else {
                this.helpFrame.setState(0);
                this.helpFrame.show();
                this.helpFrame.requestFocus();
            }
        }
        if (object == this.about) {
            serializable2 = null;
            String string = "";
            if (this.language == 590) {
                string = "Noughts and Crosses  v.1.1\n   \u00a92001 Petteri Hiipakka\n       This is freeware.";
            }
            if (this.language == 976) {
                string = "      Ristinolla  v.1.1\n\u00a92001 Petteri Hiipakka\nT\u00e4m\u00e4 on ilmaisohjelma.";
            }
            if (this.appletVersion) {
                serializable2 = new JOptionPane(string, 1, -1);
            } else if (this.NACIcon != null) {
                serializable2 = new JOptionPane(string, 1, -1, this.NACIcon);
            }
            ((JComponent)serializable2).setFont(new Font("Dialog", 0, 12));
            serializable = ((JOptionPane)serializable2).createDialog(this, "");
            ((Dialog)serializable).setResizable(false);
            if (this.warningBanners) {
                if (this.appletVersion) {
                    ((Component)serializable).setSize(245, 150);
                } else {
                    ((Component)serializable).setSize(225, 150);
                }
            } else if (this.appletVersion) {
                ((Component)serializable).setSize(245, 135);
            } else {
                ((Component)serializable).setSize(225, 135);
            }
            ((Container)serializable).setFont(new Font("Dialog", 0, 12));
            this.location = this.getLocation();
            Dimension dimension = new Dimension();
            Dimension dimension2 = new Dimension();
            dimension = this.getSize();
            dimension2 = ((Component)serializable).getSize();
            this.location.x += dimension.width / 2 - dimension2.width / 2;
            this.location.y += dimension.height / 2 - dimension2.height / 2;
            ((Component)serializable).setLocation(this.location);
            ((Dialog)serializable).show();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object == this) {
            if (!this.appletVersion) {
                this.gameBoard.saveBoard();
            }
            if (this.helpFrame != null) {
                this.helpFrame.dispose();
            }
            this.dispose();
            if (!this.appletVersion) {
                System.exit(0);
            }
        }
        if (object == this.helpFrame) {
            this.helpFrame.dispose();
            this.helpFrame = null;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

